﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace IndianHealthService.BMXNet.WinForm
{
    /// <summary>
    /// The LoginProcess provides feedback after every LoginAttempt, even if the login
    /// attempt was performer using the AttemptingLoginEvent.  If a custom dialog box or action can
    /// take place and Handled set to True, the LoginProcess will not display the standard dialog.
    /// The LoginProcess is available so examine or modify.
    /// </summary>
    public class LoginAttemptedEventArgs : CancelEventArgs
    {
        public LoginProcess Process { get; set; }
        public bool WasSuccessful { get; set; }
        public bool Handled { get; set; }
    }
}
